<?php
// about.php — uses reusable header/footer

// Page settings
$pageTitle  = 'About Us - Accounting';
$activePage = 'about';              // must match a slug in $menus
// $ASSET_BASE = '';                // set to '../' if this file lives in a subfolder

// (Optional) override globals from config if you want
// $siteName = 'Accounting';
// $contact  = ['phone' => '+00 1234 567', 'email' => 'youremail@email.com'];

// Page data
$hero = [
  'bg'   => 'images/bg_2.jpg',
  'title'=> 'About Us',
  'crumbs'=> [
    ['label' => 'Home', 'href' => 'index.php'],
    ['label' => 'About us', 'href' => null],
  ],
];

$testimonials = [
  ['img' => 'images/person_1.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_2.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_3.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_1.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_2.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
];

$faqs = [
  ['id'=>'One','q'=>'How to fixed a problem?','items'=>[
    'Far far away, behind the word mountains',
    'Consonantia, there live the blind texts',
    'When she reached the first hills of the Italic Mountains',
    'Bookmarksgrove, the headline of Alphabet Village',
    'Separated they live in Bookmarksgrove right'
  ], 'show'=>true],
  ['id'=>'Two','q'=>'How to manage your business loans?','items'=>[
    'Far far away, behind the word mountains',
    'Consonantia, there live the blind texts',
    'When she reached the first hills of the Italic Mountains',
    'Bookmarksgrove, the headline of Alphabet Village',
    'Separated they live in Bookmarksgrove right'
  ]],
  ['id'=>'Three','q'=>'How to grow your investments funds?','items'=>[
    'Far far away, behind the word mountains',
    'Consonantia, there live the blind texts',
    'When she reached the first hills of the Italic Mountains',
    'Bookmarksgrove, the headline of Alphabet Village',
    'Separated they live in Bookmarksgrove right'
  ]],
  ['id'=>'Four','q'=>'What are those requirements for businesses?','p'=>
    'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.'
  ],
];

// Include header (loads config + <head> + navbar)
require_once __DIR__ . '/partials/header.php';
?>

<!-- ================== PAGE CONTENT ================== -->

<section class="hero-wrap hero-wrap-2" style="background-image: url('<?= e($hero['bg']) ?>');" data-stellar-background-ratio="0.5">
  <div class="overlay"></div>
  <div class="container">
    <div class="row no-gutters slider-text align-items-end">
      <div class="col-md-9 ftco-animate pb-5">
        <p class="breadcrumbs mb-2">
          <?php foreach ($hero['crumbs'] as $i => $c): ?>
            <span class="<?= $i === 0 ? 'mr-2' : '' ?>">
              <?php if (!empty($c['href'])): ?>
                <a href="<?= e($c['href']) ?>"><?= e($c['label']) ?> <i class="ion-ios-arrow-forward"></i></a>
              <?php else: ?>
                <?= e($c['label']) ?> <i class="ion-ios-arrow-forward"></i>
              <?php endif; ?>
            </span>
          <?php endforeach; ?>
        </p>
        <h1 class="mb-0 bread"><?= e($hero['title']) ?></h1>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pt bg-light">
  <div class="container">
    <div class="row d-flex no-gutters">
      <div class="col-md-6 d-flex">
        <div class="img img-video d-flex align-self-stretch align-items-center justify-content-center justify-content-md-center mb-4 mb-sm-0" style="background-image:url(images/about.jpg);"></div>
      </div>
      <div class="col-md-6 pl-md-5 py-md-5">
        <div class="heading-section pl-md-4 pt-md-5">
          <span class="subheading">Welcome to Accounting</span>
          <h2 class="mb-4">We Are the Best Accounting Agency</h2>
          <p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>
          <p>A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="ftco-counter bg-light ftco-no-pt" id="section-counter">
  <div class="container">
    <div class="row">
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="50">0</strong></div>
          <div class="text"><span>Years of Experienced</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="8500">0</strong></div>
          <div class="text"><span>Cases Completed</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="20">0</strong></div>
          <div class="text"><span>Awards Won</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="50">0</strong></div>
          <div class="text"><span>Expert Consultant</span></div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section testimony-section bg-light">
  <div class="overlay"></div>
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section heading-section-white text-center ftco-animate">
        <span class="subheading">Testimonies</span>
        <h2>Happy Clients &amp; Feedbacks</h2>
      </div>
    </div>
    <div class="row ftco-animate">
      <div class="col-md-12">
        <div class="carousel-testimony owl-carousel ftco-owl">
          <?php foreach ($testimonials as $t): ?>
            <div class="item">
              <div class="testimony-wrap py-4">
                <div class="icon d-flex align-items-center justify-content-center"><span class="fa fa-quote-left"></span></div>
                <div class="text">
                  <p class="mb-4"><?= e($t['text']) ?></p>
                  <div class="d-flex align-items-center">
                    <div class="user-img" style="background-image: url(<?= e($t['img']) ?>)"></div>
                    <div class="pl-3">
                      <p class="name"><?= e($t['name']) ?></p>
                      <span class="position"><?= e($t['role']) ?></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pt bg-light ftco-faqs">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        <div class="img-faqs w-100">
          <div class="img mb-4 mb-sm-0" style="background-image:url(images/about-2.jpg);"></div>
          <div class="img img-2 mb-4 mb-sm-0" style="background-image:url(images/about-1.jpg);"></div>
        </div>
      </div>
      <div class="col-lg-6 pl-lg-5">
        <div class="heading-section mb-5 mt-5 mt-lg-0">
          <span class="subheading">FAQs</span>
          <h2 class="mb-3">Frequently Asks Questions</h2>
          <p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>
        </div>

        <div id="accordion" class="myaccordion w-100" aria-multiselectable="true">
          <?php foreach ($faqs as $f): ?>
            <?php
              $collapseId = 'collapse'.$f['id'];
              $headingId  = 'heading'.$f['id'];
              $isOpen     = !empty($f['show']);
            ?>
            <div class="card">
              <div class="card-header p-0" id="<?= e($headingId) ?>">
                <h2 class="mb-0">
                  <button href="#<?= e($collapseId) ?>" class="d-flex py-3 px-4 align-items-center justify-content-between btn btn-link"
                          data-parent="#accordion" data-toggle="collapse"
                          aria-expanded="<?= $isOpen ? 'true':'false' ?>" aria-controls="<?= e($collapseId) ?>">
                    <p class="mb-0"><?= e($f['q']) ?></p>
                    <i class="fa" aria-hidden="true"></i>
                  </button>
                </h2>
              </div>
              <div class="collapse <?= $isOpen ? 'show':'' ?>" id="<?= e($collapseId) ?>" role="tabpanel" aria-labelledby="<?= e($headingId) ?>">
                <div class="card-body py-3 px-0">
                  <?php if (!empty($f['p'])): ?>
                    <p><?= e($f['p']) ?></p>
                  <?php else: ?>
                    <ol>
                      <?php foreach ($f['items'] as $li): ?>
                        <li><?= e($li) ?></li>
                      <?php endforeach; ?>
                    </ol>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>

      </div>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pb ftco-no-pt bg-secondary">
  <div class="container py-5">
    <div class="row">
      <div class="col-md-7 d-flex align-items-center">
        <h2 class="mb-3 mb-sm-0" style="color:black; font-size: 22px;">Sign Up for Your Free 1st Accounting Consultation</h2>
      </div>
      <div class="col-md-5 d-flex align-items-center">
        <form action="#" class="subscribe-form">
          <div class="form-group d-flex">
            <input type="text" class="form-control" placeholder="Enter email address">
            <input type="submit" value="Subscribe" class="submit px-3">
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ================== /PAGE CONTENT ================== -->

<?php require_once __DIR__ . '/partials/footer.php'; ?>
