<?php
// contact.php — uses reusable header/footer

// Page settings
$pageTitle  = 'Contact Us - Accounting';
$activePage = 'contact';        // must match a slug in $menus
// $ASSET_BASE = '';            // set to '../' if this file is in a subfolder

$mapAddress = 'Plot 2542, Hassan Usman Katsina Street, Asokoro District, Abuja, FCT, Nigeria.';
$mapSrc = 'https://www.google.com/maps?q=' . rawurlencode($mapAddress) . '&output=embed';


// Simple form handling (server-side validation; replace with mail() if needed)
$errors  = [];
$success = false;

$name = $email = $subject = $message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name    = trim($_POST['name']    ?? '');
  $email   = trim($_POST['email']   ?? '');
  $subject = trim($_POST['subject'] ?? '');
  $message = trim($_POST['message'] ?? '');

  if ($name === '')                                      $errors['name']    = 'Please enter your name.';
  if (!filter_var($email, FILTER_VALIDATE_EMAIL))        $errors['email']   = 'Please enter a valid email address.';
  if ($subject === '')                                   $errors['subject'] = 'Please enter a subject.';
  if ($message === '')                                   $errors['message'] = 'Please enter a message.';

  if (!$errors) {
    // Example: send an email (uncomment & set a valid recipient)
    // $to = $contact['email'] ?? 'you@example.com';
    // @mail($to, "Contact form: {$subject}", "From: {$name} <{$email}>\r\n\r\n{$message}");
    $success = true;
    // Optionally clear fields after success
    $name = $email = $subject = $message = '';
  }
}

require_once __DIR__ . '/partials/header.php';
?>

<!-- ================== PAGE CONTENT ================== -->

<section class="hero-wrap hero-wrap-2" style="background-image: url('images/bg_2.jpg');" data-stellar-background-ratio="0.5">
  <div class="overlay"></div>
  <div class="container">
    <div class="row no-gutters slider-text align-items-end">
      <div class="col-md-9 ftco-animate pb-5">
        <p class="breadcrumbs mb-2">
          <span class="mr-2"><a href="index.php">Home <i class="ion-ios-arrow-forward"></i></a></span>
          <span>Contact Us <i class="ion-ios-arrow-forward"></i></span>
        </p>
        <h1 class="mb-0 bread">Contact Us</h1>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section bg-light">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-12">
        <div class="wrapper">
          <div class="row no-gutters">
            <div class="col-lg-8 col-md-7 order-md-last d-flex align-items-stretch">
              <div class="contact-wrap w-100 p-md-5 p-4">
                <h3 class="mb-4">Get in touch</h3>

                <?php if ($success): ?>
                  <div id="form-message-success" class="mb-4">Your message was sent, thank you!</div>
                <?php elseif ($errors): ?>
                  <div id="form-message-warning" class="mb-4">
                    Please fix the errors below and try again.
                  </div>
                <?php endif; ?>

                <form method="POST" id="contactForm" name="contactForm" class="contactForm" action="">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label class="label" for="name">Full Name</label>
                        <input type="text" class="form-control <?= isset($errors['name']) ? 'is-invalid' : '' ?>"
                               name="name" id="name" placeholder="Name" value="<?= e($name) ?>">
                        <?php if (isset($errors['name'])): ?><div class="invalid-feedback d-block"><?= e($errors['name']) ?></div><?php endif; ?>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label class="label" for="email">Email Address</label>
                        <input type="email" class="form-control <?= isset($errors['email']) ? 'is-invalid' : '' ?>"
                               name="email" id="email" placeholder="Email" value="<?= e($email) ?>">
                        <?php if (isset($errors['email'])): ?><div class="invalid-feedback d-block"><?= e($errors['email']) ?></div><?php endif; ?>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group">
                        <label class="label" for="subject">Subject</label>
                        <input type="text" class="form-control <?= isset($errors['subject']) ? 'is-invalid' : '' ?>"
                               name="subject" id="subject" placeholder="Subject" value="<?= e($subject) ?>">
                        <?php if (isset($errors['subject'])): ?><div class="invalid-feedback d-block"><?= e($errors['subject']) ?></div><?php endif; ?>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group">
                        <label class="label" for="message">Message</label>
                        <textarea name="message" class="form-control <?= isset($errors['message']) ? 'is-invalid' : '' ?>"
                                  id="message" cols="30" rows="4" placeholder="Message"><?= e($message) ?></textarea>
                        <?php if (isset($errors['message'])): ?><div class="invalid-feedback d-block"><?= e($errors['message']) ?></div><?php endif; ?>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group">
                        <input type="submit" value="Send Message" class="btn btn-primary">
                        <div class="submitting"></div>
                      </div>
                    </div>
                  </div>
                </form>

              </div>
            </div>
            <div class="col-lg-4 col-md-5 d-flex align-items-stretch">
              <div class="info-wrap bg-primary w-100 p-md-5 p-4">
                <h3>Let's get in touch</h3>
                <p class="mb-4">We're open for any suggestion or just to have a chat</p>

                <div class="dbox w-100 d-flex align-items-start">
                  <div class="icon d-flex align-items-center justify-content-center">
                    <span class="fa fa-map-marker"></span>
                  </div>
                  <div class="text pl-3">
                    <p><span>Address:</span> Plot 2542, Hassan Usman Katsina Street, Asokoro District, Abuja, FCT, Nigeria.</p>
                  </div>
                </div>

                <div class="dbox w-100 d-flex align-items-center">
                  <div class="icon d-flex align-items-center justify-content-center">
                    <span class="fa fa-phone"></span>
                  </div>
                  <div class="text pl-3">
                    <p><span>Phone:</span> <a href="tel://1234567920"><?= e($contact['phone'] ?? '+00 1234 567') ?></a></p>
                  </div>
                </div>

                <div class="dbox w-100 d-flex align-items-center">
                  <div class="icon d-flex align-items-center justify-content-center">
                    <span class="fa fa-paper-plane"></span>
                  </div>
                  <div class="text pl-3">
                    <p><span>Email:</span> <a href="mailto:<?= e($contact['email'] ?? 'info@yoursite.com') ?>"><?= e($contact['email'] ?? 'info@yoursite.com') ?></a></p>
                  </div>
                </div>

                <div class="dbox w-100 d-flex align-items-center">
                  <div class="icon d-flex align-items-center justify-content-center">
                    <span class="fa fa-globe"></span>
                  </div>
                  <div class="text pl-3">
                    <p><span>Website</span> <a href="#">yoursite.com</a></p>
                  </div>
                </div>

              </div>
            </div>
          </div><!-- row -->
        </div><!-- wrapper -->
      </div>
    </div>
  </div>
</section>

<!-- Key-free Google Maps embed -->
<div class="embed-responsive embed-responsive-21by9 shadow-sm" style="min-height:360px;">
  <iframe
    class="embed-responsive-item"
    src="<?= e($mapSrc) ?>"
    loading="lazy"
    allowfullscreen
    referrerpolicy="no-referrer-when-downgrade">
  </iframe>
</div>
<p class="text-center small mt-2 mb-0">
  <a href="https://www.google.com/maps/search/?api=1&query=<?= rawurlencode($mapAddress) ?>" target="_blank" rel="noopener">
    Open in Google Maps
  </a>
</p>


<section class="ftco-section ftco-no-pb ftco-no-pt bg-secondary">
  <div class="container py-5">
    <div class="row">
      <div class="col-md-7 d-flex align-items-center">
        <h2 class="mb-3 mb-sm-0" style="color:black; font-size: 22px;">Sign Up for Your Free 1st Accounting Consultation</h2>
      </div>
      <div class="col-md-5 d-flex align-items-center">
        <form action="#" class="subscribe-form">
          <div class="form-group d-flex">
            <input type="text" class="form-control" placeholder="Enter email address">
            <input type="submit" value="Subscribe" class="submit px-3">
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ================== /PAGE CONTENT ================== -->

<?php require_once __DIR__ . '/partials/footer.php'; ?>
