<?php
// inc/config.php
// Global settings shared by all pages

$siteName  = $siteName  ?? 'Accounting';
$contact   = $contact   ?? ['phone' => '+234 813 553 7879', 'email' => 'info@paysync.com'];
$useGoogleMapsApi = $useGoogleMapsApi ?? false;


// If you ever move a page into a subfolder, set $ASSET_BASE = '../' in that page BEFORE including header.php
$ASSET_BASE = $ASSET_BASE ?? ''; // e.g. '' for root pages, '../' inside subfolders

// Main navigation (slug is used to highlight the active menu)
$menus = $menus ?? [
  ['href' => 'index.php',   'label' => 'Home',       'slug' => 'home'],
  ['href' => 'about.php',   'label' => 'About',      'slug' => 'about'],
  ['href' => 'services.php','label' => 'Services',   'slug' => 'services'],
 
  ['href' => 'contact.php', 'label' => 'Contact',    'slug' => 'contact'],
];

// Auth / Login button config
$auth = $auth ?? [
  'logged_in'   => false,         // set to true after your auth flow
  'user_name'   => null,          // e.g. 'Jane Doe' when logged in
  'login_href'  => '../account/login.php',  //'login.php'
  'logout_href' => 'logout.php',
  'login_label' => 'Login',
];


// Simple esc helper
if (!function_exists('e')) {
  function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
}
