<?php
// index.php — uses reusable partials

/* ---------- Page settings ---------- */
$pageTitle  = 'Accounting - Home';
$activePage = 'home';        // must match a slug in $menus
// $ASSET_BASE = '';         // only if this file lives in a subfolder

/* ---------- (Optional) override global config values ---------- */
$siteName = 'Pay Sync';
$contact  = [
  'phone' => '+00 1234 567',
  'email' => 'info@paysyc.com',
];

// IMPORTANT: use slug for active highlighting
$menus = [
  ['href' => 'index.php',   'label' => 'Home',       'slug' => 'home'],
  ['href' => 'about.php',   'label' => 'About',      'slug' => 'about'],
  ['href' => 'services.php','label' => 'Services',   'slug' => 'services'],
  //['href' => 'cases.php',   'label' => 'Case Study', 'slug' => 'cases'],
  //['href' => 'blog.php',    'label' => 'Blog',       'slug' => 'blog'],
  ['href' => 'contact.php', 'label' => 'Contact',    'slug' => 'contact'],
];

/* ---------- Page-only data ---------- */
$slides = [
  ['bg' => 'images/bg_1.jpg', 'h2' => 'We Business Grow',  'h1' => 'We Help You Businesses Innovate and Grow'],
  ['bg' => 'images/bg_2.png', 'h2' => 'We Support Business','h1' => 'The Best Business Support'],
  ['bg' => 'images/bg_3.jpg', 'h2' => 'We Give Advice',    'h1' => 'Expert Financial Advice'],
];

$aboutServices = [
  ['icon' => 'flaticon-wealth',     'title' => 'Market Analysis',       'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
  ['icon' => 'flaticon-accountant', 'title' => 'Accounting Advisor',    'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
  ['icon' => 'flaticon-teamwork',   'title' => 'General Consultancy',   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
  ['icon' => 'flaticon-accounting', 'title' => 'Structured Assestment', 'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
];

$featureServices = [
  ['icon' => 'flaticon-accounting-1', 'title' => 'Accounting',                'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
  ['icon' => 'flaticon-tax',          'title' => 'Tax, Compliance & Payroll', 'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
  ['icon' => 'flaticon-loan',         'title' => 'Financial Services',        'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
  ['icon' => 'flaticon-budget',       'title' => 'wallet & Funding Access',   'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
];

$testimonials = [
  ['img' => 'images/person_1.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_2.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_3.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_1.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
  ['img' => 'images/person_2.jpg', 'name' => 'Roger Scott', 'role' => 'Marketing Manager',
   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.'],
];

$blogPosts = [
  ['date' => 'March 31, 2020', 'author' => 'Admin', 'comments' => 3, 'img' => 'images/image_1.jpg',
   'title' => 'Even the all-powerful Pointing has no control about the blind texts', 'link' => 'blog-single.php'],
  ['date' => 'March 31, 2020', 'author' => 'Admin', 'comments' => 3, 'img' => 'images/image_2.jpg',
   'title' => 'Even the all-powerful Pointing has no control about the blind texts', 'link' => 'blog-single.php'],
  ['date' => 'March 31, 2020', 'author' => 'Admin', 'comments' => 3, 'img' => 'images/image_3.jpg',
   'title' => 'Even the all-powerful Pointing has no control about the blind texts', 'link' => 'blog-single.php'],
];

$plans = [
  ['name' => 'Personal', 'price' => 49,  'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
  ['name' => 'Business', 'price' => 79,  'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
  ['name' => 'Ultimate', 'price' => 109, 'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
  ['name' => 'Premium',  'price' => 149, 'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
];

// esc helper only if not already defined by config/header
if (!function_exists('e')) {
  function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
}

/* ---------- Include reusable header ---------- */
require_once __DIR__ . '/partials/header.php';
?>

<!-- ================== PAGE CONTENT ONLY (no <html>, <head>, navbar, or footer here) ================== -->

<div class="hero-wrap">
  <div class="home-slider owl-carousel">
    <?php foreach ($slides as $s): ?>
      <div class="slider-item" style="background-image:url(<?= e($s['bg']) ?>);">
        <div class="overlay"></div>
        <div class="container">
          <div class="row no-gutters slider-text align-items-center justify-content-center">
            <div class="col-md-8 ftco-animate">
              <div class="text w-100 text-center">
                <h2><?= e($s['h2']) ?></h2>
                <h1 class="mb-4"><?= e($s['h1']) ?></h1>
                <p><a href="#" class="btn btn-white">Connect with us</a></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<section class="ftco-section ftco-no-pt bg-light">
  <div class="container">
    <div class="row d-flex no-gutters">
      <div class="col-md-6 d-flex">
        <div class="img img-video d-flex align-self-stretch align-items-center justify-content-center justify-content-md-center mb-4 mb-sm-0" style="background-image:url(images/about.jpg);"></div>
      </div>
      <div class="col-md-6 pl-md-5 py-md-5">
        <div class="heading-section pl-md-4 pt-md-5">
          <span class="subheading">Welcome to <?= e($siteName) ?></span>
          <h2 class="mb-4">We Are the Best Accounting Agency</h2>
        </div>

        <?php foreach ($aboutServices as $svc): ?>
          <div class="services-2 w-100 d-flex">
            <div class="icon d-flex align-items-center justify-content-center"><span class="<?= e($svc['icon']) ?>"></span></div>
            <div class="text pl-4">
              <h4><?= e($svc['title']) ?></h4>
              <p><?= e($svc['text']) ?></p>
            </div>
          </div>
        <?php endforeach; ?>

      </div>
    </div>
  </div>
</section>

<section class="ftco-section bg-light ftco-no-pt">
  <div class="container">
    <div class="row">
      <?php foreach ($featureServices as $svc): ?>
        <div class="col-md-6 col-lg-3 d-flex services align-self-stretch px-4 ftco-animate">
          <div class="d-block">
            <div class="icon d-flex mr-2"><span class="<?= e($svc['icon']) ?>"></span></div>
            <div class="media-body">
              <h3 class="heading"><?= e($svc['title']) ?></h3>
              <p><?= e($svc['text']) ?></p>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<section class="ftco-counter bg-light ftco-no-pt" id="section-counter">
  <div class="container">
    <div class="row">
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="10">0</strong></div>
          <div class="text"><span>Years of Experienced</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="500">0</strong></div>
          <div class="text"><span>Cases Completed</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="20">0</strong></div>
          <div class="text"><span>Awards Won</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="50">0</strong></div>
          <div class="text"><span>Expert Consultant</span></div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section testimony-section bg-light">
  <div class="overlay"></div>
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section heading-section-white text-center ftco-animate">
        <span class="subheading">Testimonies</span>
        <h2>Happy Clients &amp; Feedbacks</h2>
      </div>
    </div>
    <div class="row ftco-animate">
      <div class="col-md-12">
        <div class="carousel-testimony owl-carousel ftco-owl">
          <?php foreach ($testimonials as $t): ?>
            <div class="item">
              <div class="testimony-wrap py-4">
                <div class="icon d-flex align-items-center justify-content-center"><span class="fa fa-quote-left"></span></div>
                <div class="text">
                  <p class="mb-4"><?= e($t['text']) ?></p>
                  <div class="d-flex align-items-center">
                    <div class="user-img" style="background-image: url(<?= e($t['img']) ?>)"></div>
                    <div class="pl-3">
                      <p class="name"><?= e($t['name']) ?></p>
                      <span class="position"><?= e($t['role']) ?></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pt bg-light ftco-faqs">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        <div class="img-faqs w-100">
          <div class="img mb-4 mb-sm-0" style="background-image:url(images/about-2.png);"></div>
          <div class="img img-2 mb-4 mb-sm-0" style="background-image:url(images/about-1.png);"></div>
        </div>
      </div>
      <div class="col-lg-6 pl-lg-5">
        <div class="heading-section mb-5 mt-5 mt-lg-0">
          <span class="subheading">FAQs</span>
          <h2 class="mb-3">Frequently Asks Questions</h2>
          <p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.</p>
        </div>

        <div id="accordion" class="myaccordion w-100" aria-multiselectable="true">
          <?php
          $faqs = [
            ['id'=>'One','q'=>'How to fixed a problem?','items'=>[
              'Far far away, behind the word mountains',
              'Consonantia, there live the blind texts',
              'When she reached the first hills of the Italic Mountains',
              'Bookmarksgrove, the headline of Alphabet Village',
              'Separated they live in Bookmarksgrove right'
            ], 'show'=>true],
            ['id'=>'Two','q'=>'How to manage your business loans?','items'=>[
              'Far far away, behind the word mountains',
              'Consonantia, there live the blind texts',
              'When she reached the first hills of the Italic Mountains',
              'Bookmarksgrove, the headline of Alphabet Village',
              'Separated they live in Bookmarksgrove right'
            ]],
            ['id'=>'Three','q'=>'How to grow your investments funds?','items'=>[
              'Far far away, behind the word mountains',
              'Consonantia, there live the blind texts',
              'When she reached the first hills of the Italic Mountains',
              'Bookmarksgrove, the headline of Alphabet Village',
              'Separated they live in Bookmarksgrove right'
            ]],
            ['id'=>'Four','q'=>'What are those requirements for businesses?','p'=>
              'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.'
            ],
          ];
          foreach ($faqs as $f):
            $collapseId = 'collapse'.$f['id'];
            $headingId  = 'heading'.$f['id'];
            $isOpen     = !empty($f['show']);
          ?>
          <div class="card">
            <div class="card-header p-0" id="<?= e($headingId) ?>">
              <h2 class="mb-0">
                <button href="#<?= e($collapseId) ?>" class="d-flex py-3 px-4 align-items-center justify-content-between btn btn-link"
                        data-parent="#accordion" data-toggle="collapse"
                        aria-expanded="<?= $isOpen ? 'true':'false' ?>" aria-controls="<?= e($collapseId) ?>">
                  <p class="mb-0"><?= e($f['q']) ?></p>
                  <i class="fa" aria-hidden="true"></i>
                </button>
              </h2>
            </div>
            <div class="collapse <?= $isOpen ? 'show':'' ?>" id="<?= e($collapseId) ?>" role="tabpanel" aria-labelledby="<?= e($headingId) ?>">
              <div class="card-body py-3 px-0">
                <?php if (!empty($f['p'])): ?>
                  <p><?= e($f['p']) ?></p>
                <?php else: ?>
                  <ol>
                    <?php foreach ($f['items'] as $li): ?>
                      <li><?= e($li) ?></li>
                    <?php endforeach; ?>
                  </ol>
                <?php endif; ?>
              </div>
            </div>
          </div>
          <?php endforeach; ?>
        </div>

      </div>
    </div>
  </div>
</section>

<section class="ftco-section">
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section text-center ftco-animate">
        <span class="subheading">News &amp; Blog</span>
        <h2>Latest news from our blog</h2>
      </div>
    </div>
    <div class="row d-flex">
      <?php foreach ($blogPosts as $b): ?>
        <div class="col-md-4 d-flex ftco-animate">
          <div class="blog-entry align-self-stretch">
            <a href="<?= e($b['link']) ?>" class="block-20 rounded" style="background-image: url('<?= e($b['img']) ?>');"></a>
            <div class="text p-4">
              <div class="meta mb-2">
                <div><a href="#"><?= e($b['date']) ?></a></div>
                <div><a href="#"><?= e($b['author']) ?></a></div>
                <div><a href="#" class="meta-chat"><span class="fa fa-comment"></span> <?= (int)$b['comments'] ?></a></div>
              </div>
              <h3 class="heading"><a href="<?= e($b['link']) ?>"><?= e($b['title']) ?></a></h3>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pb ftco-no-pt bg-secondary">
  <div class="container py-5">
    <div class="row">
      <div class="col-md-7 d-flex align-items-center">
        <h2 class="mb-3 mb-sm-0" style="color:black; font-size: 22px;">Sign Up for Your Free 1st Accounting Consultation</h2>
      </div>
      <div class="col-md-5 d-flex align-items-center">
        <form action="#" class="subscribe-form">
          <div class="form-group d-flex">
            <input type="text" class="form-control" placeholder="Enter email address">
            <input type="submit" value="Subscribe" class="submit px-3">
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section bg-light">
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section text-center ftco-animate">
        <span class="subheading">Price &amp; Plans</span>
        <h2>Affordable Packages</h2>
      </div>
    </div>
    <div class="row">
      <?php foreach ($plans as $p): ?>
        <div class="col-md-6 col-lg-3 ftco-animate">
          <div class="block-7">
            <div class="text-center">
              <span class="excerpt d-block"><?= e($p['name']) ?></span>
              <span class="price"><sup>$</sup> <span class="number"><?= (int)$p['price'] ?></span> <sub>/mos</sub></span>
              <ul class="pricing-text mb-5">
                <?php foreach ($p['features'] as $f): ?>
                  <li><span class="fa fa-check mr-2"></span><?= e($f) ?></li>
                <?php endforeach; ?>
              </ul>
              <a href="#" class="btn btn-primary d-block px-2 py-3">Get Started</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ================== End page content ================== -->

<?php require_once __DIR__ . '/partials/footer.php'; ?>
