<?php
// index.php — uses reusable partials

/* ---------- Page settings ---------- */
$pageTitle  = 'Accounting - Home';
$activePage = 'home';        // must match a slug in $menus

/* ---------- (Optional) override global config values ---------- */
$siteName = 'Pay Sync';
$contact  = [
  'phone' => '+00 1234 567',
  'email' => 'info@paysync.com',
];

// IMPORTANT: use slug for active highlighting
$menus = [
  ['href' => 'index.php',   'label' => 'Home',       'slug' => 'home'],
  ['href' => 'about.php',   'label' => 'About',      'slug' => 'about'],
  ['href' => 'services.php','label' => 'Services',   'slug' => 'services'],
  ['href' => 'contact.php', 'label' => 'Contact',    'slug' => 'contact'],
];

/* ---------- Page-only data (COPY UPDATED, UI UNCHANGED) ---------- */
$slides = [
  [
    'bg' => 'images/bg_1.jpg',
    'h2' => 'Pay Sync centralizes expense requests, approvals, and disbursements across multiple companies—complete with budgets, analytics, and a tamper-evident audit log.',
    'h1' => 'Control Spend. Close Faster. Stay Audit-Ready.'
  ],
  [
    'bg' => 'images/bg_2.png',
    'h2' => 'Trusted by finance teams, founders, and audit partners across Africa.',
    'h1' => 'One Source of Truth for spend'
  ],
  [
    'bg' => 'images/bg_3.jpg',
    'h2' => 'Approvals that match your policy. Budgets & analytics built-in.',
    'h1' => 'Audit-Ready by Design'
  ],
];

/* “Who it’s for” — mapped into the About/Services list on the right */
$aboutServices = [
  [
    'icon' => 'flaticon-teamwork',
    'title' => 'Staff',
    'text'  => 'Submit requests, upload receipts, and track status in real time.'
  ],
  [
    'icon' => 'flaticon-accountant',
    'title' => 'Finance',
    'text'  => 'Approve, disburse, reconcile—see exceptions first with clear queues.'
  ],
  [
    'icon' => 'flaticon-wealth',
    'title' => 'Company Admin',
    'text'  => 'Manage users, permissions, groups, budgets, and approval policies.'
  ],
  [
    'icon' => 'flaticon-accounting',
    'title' => 'Audit Firm (Super Admin)',
    'text'  => 'Read-only access across companies with global reporting and exports.'
  ],
];

/* Value Proposition — mapped to the 4 feature cards section (kept 4th for Budgets/Analytics) */
$featureServices = [
  [
    'icon' => 'flaticon-accounting-1',
    'title' => 'One Source of Truth',
    'text'  => 'Every request, approval, receipt, and note in one place, linked to the right company and cost group.'
  ],
  [
    'icon' => 'flaticon-tax',
    'title' => 'Approvals That Match Policy',
    'text'  => 'Single or multi-level approvals by amount, urgency, or budget thresholds.'
  ],
  [
    'icon' => 'flaticon-loan',
    'title' => 'Audit-Ready by Design',
    'text'  => 'Immutable log of who did what and when; export to CSV, PDF, or XBRL for filings.'
  ],
  [
    'icon' => 'flaticon-budget',
    'title' => 'Budgets & Analytics',
    'text'  => 'Monthly budgets per group with alerts; drill from KPIs to individual requests and evidence.'
  ],
];

/* Social proof & testimonials — replaced with your samples */
$testimonials = [
  [
    'img' => 'images/person_1.jpg',
    'name' => 'Ada',
    'role' => 'Finance Lead',
    'text' => '“Our month-end close dropped from 8 days to 4. The audit trail saved us countless emails.”'
  ],
  [
    'img' => 'images/person_2.jpg',
    'name' => 'Samuel',
    'role' => 'Operations',
    'text' => '“I submit a request and can see exactly where it is. No more guessing.”'
  ],
  [
    'img' => 'images/person_3.jpg',
    'name' => 'Kemi',
    'role' => 'Audit Partner',
    'text' => '“As auditors, read-only access and XBRL exports changed the game.”'
  ],
];

/* Leave blog posts as-is for now */
$blogPosts = [
  ['date' => 'March 31, 2020', 'author' => 'Admin', 'comments' => 3, 'img' => 'images/image_1.jpg',
   'title' => 'Even the all-powerful Pointing has no control about the blind texts', 'link' => 'blog-single.php'],
  ['date' => 'March 31, 2020', 'author' => 'Admin', 'comments' => 3, 'img' => 'images/image_2.jpg',
   'title' => 'Even the all-powerful Pointing has no control about the blind texts', 'link' => 'blog-single.php'],
  ['date' => 'March 31, 2020', 'author' => 'Admin', 'comments' => 3, 'img' => 'images/image_3.jpg',
   'title' => 'Even the all-powerful Pointing has no control about the blind texts', 'link' => 'blog-single.php'],
];

/* Plans — text-only tweak to match your product tone (UI unchanged) */
$plans = [
  ['name' => 'Starter',   'price' => 49,  'features' => ['Requests & Attachments','Budgets per Group','CSV/XLSX Exports','Basic Analytics','Email Support']],
  ['name' => 'Growth',    'price' => 79,  'features' => ['Multi-Level Approvals','Advanced Filters & Search','PDF Audit Packs','Comments & Mentions','Priority Support']],
  ['name' => 'Scale',     'price' => 109, 'features' => ['AI Categorization (NLP)','Fraud & Anomaly Flags','Role Dashboards','Over-Budget Alerts','Dark Mode']],
  ['name' => 'Enterprise','price' => 149, 'features' => ['Tamper-Evident Audit Log','XBRL Exports','SLA Controls','SAML/2FA Policies','Webhooks & Integrations']],
];

// esc helper only if not already defined by config/header
if (!function_exists('e')) {
  function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
}

/* ---------- Include reusable header ---------- */
require_once __DIR__ . '/partials/header.php';
?>

<!-- ================== PAGE CONTENT ONLY (no <html>, <head>, navbar, or footer here) ================== -->

<div class="hero-wrap">
  <div class="home-slider owl-carousel">
    <?php foreach ($slides as $s): ?>
      <div class="slider-item" style="background-image:url(<?= e($s['bg']) ?>);">
        <div class="overlay"></div>
        <div class="container">
          <div class="row no-gutters slider-text align-items-center justify-content-center">
            <div class="col-md-8 ftco-animate">
              <div class="text w-100 text-center">
                <h2><?= e($s['h2']) ?></h2>
                <h1 class="mb-4"><?= e($s['h1']) ?></h1>
                <!-- Kept single CTA button exactly as your UI; just changed label -->
                <p><a href="#" class="btn btn-white">Get a Demo</a></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<section class="ftco-section ftco-no-pt bg-light">
  <div class="container">
    <div class="row d-flex no-gutters">
      <div class="col-md-6 d-flex">
        <div class="img img-video d-flex align-self-stretch align-items-center justify-content-center justify-content-md-center mb-4 mb-sm-0" style="background-image:url(images/about.jpg);"></div>
      </div>
      <div class="col-md-6 pl-md-5 py-md-5">
        <div class="heading-section pl-md-4 pt-md-5">
          <span class="subheading">Who It’s For</span>
          <h2 class="mb-4">Staff • Finance • Admin • Audit</h2>
        </div>

        <?php foreach ($aboutServices as $svc): ?>
          <div class="services-2 w-100 d-flex">
            <div class="icon d-flex align-items-center justify-content-center"><span class="<?= e($svc['icon']) ?>"></span></div>
            <div class="text pl-4">
              <h4><?= e($svc['title']) ?></h4>
              <p><?= e($svc['text']) ?></p>
            </div>
          </div>
        <?php endforeach; ?>

      </div>
    </div>
  </div>
</section>

<section class="ftco-section bg-light ftco-no-pt">
  <div class="container">
    <div class="row">
      <?php foreach ($featureServices as $svc): ?>
        <div class="col-md-6 col-lg-3 d-flex services align-self-stretch px-4 ftco-animate">
          <div class="d-block">
            <div class="icon d-flex mr-2"><span class="<?= e($svc['icon']) ?>"></span></div>
            <div class="media-body">
              <h3 class="heading"><?= e($svc['title']) ?></h3>
              <p><?= e($svc['text']) ?></p>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<section class="ftco-counter bg-light ftco-no-pt" id="section-counter">
  <div class="container">
    <div class="row">
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="10">0</strong></div>
          <div class="text"><span>Years of Experience</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="500">0</strong></div>
          <div class="text"><span>Companies & Teams Supported</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="20">0</strong></div>
          <div class="text"><span>Industries Served</span></div>
        </div>
      </div>
      <div class="col-md-6 col-lg-3 d-flex justify-content-center counter-wrap ftco-animate">
        <div class="block-18 text-center">
          <div class="text"><strong class="number" data-number="50">0</strong></div>
          <div class="text"><span>Audit Partnerships</span></div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section testimony-section bg-light">
  <div class="overlay"></div>
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section heading-section-white text-center ftco-animate">
        <span class="subheading">Trusted by teams across Africa</span>
        <h2>Happy Clients &amp; Feedback</h2>
      </div>
    </div>
    <div class="row ftco-animate">
      <div class="col-md-12">
        <div class="carousel-testimony owl-carousel ftco-owl">
          <?php foreach ($testimonials as $t): ?>
            <div class="item">
              <div class="testimony-wrap py-4">
                <div class="icon d-flex align-items-center justify-content-center"><span class="fa fa-quote-left"></span></div>
                <div class="text">
                  <p class="mb-4"><?= e($t['text']) ?></p>
                  <div class="d-flex align-items-center">
                    <div class="user-img" style="background-image: url(<?= e($t['img']) ?>)"></div>
                    <div class="pl-3">
                      <p class="name"><?= e($t['name']) ?></p>
                      <span class="position"><?= e($t['role']) ?></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pt bg-light ftco-faqs">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        <div class="img-faqs w-100">
          <div class="img mb-4 mb-sm-0" style="background-image:url(images/about-2.png);"></div>
          <div class="img img-2 mb-4 mb-sm-0" style="background-image:url(images/about-1.png);"></div>
        </div>
      </div>
      <div class="col-lg-6 pl-lg-5">
        <div class="heading-section mb-5 mt-5 mt-lg-0">
          <span class="subheading">FAQs</span>
          <h2 class="mb-3">Frequently Asked Questions</h2>
          <p>No credit card required. Set up in minutes.</p>
        </div>

        <div id="accordion" class="myaccordion w-100" aria-multiselectable="true">
          <?php
          $faqs = [
            ['id'=>'One','q'=>'Can Admins approve and also disburse?','p'=>'Yes. If a company has no Finance users, Admin inherits finance permissions by policy.', 'show'=>true],
            ['id'=>'Two','q'=>'Can we customize approval thresholds?','p'=>'Yes—by amount, urgency, or budget impact. Single or multi-step approvals supported.'],
            ['id'=>'Three','q'=>'Does AI decide approvals?','p'=>'No. AI assists with categorization and anomaly flags; humans make approval decisions.'],
            ['id'=>'Four','q'=>'Can we import past expenses?','p'=>'Yes. Use the CSV import with a row-level validation report.'],
            ['id'=>'Five','q'=>'What about multiple companies?','p'=>'Each company is isolated. Super Admin (audit firm) has read-only global access.'],
            ['id'=>'Six','q'=>'How do we export for auditors?','p'=>'CSV/XLSX/PDF/XBRL exports with evidence links and a full audit trail.'],
          ];
          foreach ($faqs as $f):
            $collapseId = 'collapse'.$f['id'];
            $headingId  = 'heading'.$f['id'];
            $isOpen     = !empty($f['show']);
          ?>
          <div class="card">
            <div class="card-header p-0" id="<?= e($headingId) ?>">
              <h2 class="mb-0">
                <button href="#<?= e($collapseId) ?>" class="d-flex py-3 px-4 align-items-center justify-content-between btn btn-link"
                        data-parent="#accordion" data-toggle="collapse"
                        aria-expanded="<?= $isOpen ? 'true':'false' ?>" aria-controls="<?= e($collapseId) ?>">
                  <p class="mb-0"><?= e($f['q']) ?></p>
                  <i class="fa" aria-hidden="true"></i>
                </button>
              </h2>
            </div>
            <div class="collapse <?= $isOpen ? 'show':'' ?>" id="<?= e($collapseId) ?>" role="tabpanel" aria-labelledby="<?= e($headingId) ?>">
              <div class="card-body py-3 px-0">
                <p><?= e($f['p']) ?></p>
              </div>
            </div>
          </div>
          <?php endforeach; ?>
        </div>

      </div>
    </div>
  </div>
</section>

<section class="ftco-section">
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section text-center ftco-animate">
        <span class="subheading">News &amp; Blog</span>
        <h2>Latest news from our blog</h2>
      </div>
    </div>
    <div class="row d-flex">
      <?php foreach ($blogPosts as $b): ?>
        <div class="col-md-4 d-flex ftco-animate">
          <div class="blog-entry align-self-stretch">
            <a href="<?= e($b['link']) ?>" class="block-20 rounded" style="background-image: url('<?= e($b['img']) ?>');"></a>
            <div class="text p-4">
              <div class="meta mb-2">
                <div><a href="#"><?= e($b['date']) ?></a></div>
                <div><a href="#"><?= e($b['author']) ?></a></div>
                <div><a href="#" class="meta-chat"><span class="fa fa-comment"></span> <?= (int)$b['comments'] ?></a></div>
              </div>
              <h3 class="heading"><a href="<?= e($b['link']) ?>"><?= e($b['title']) ?></a></h3>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pb ftco-no-pt bg-secondary">
  <div class="container py-5">
    <div class="row">
      <div class="col-md-7 d-flex align-items-center">
        <h2 class="mb-3 mb-sm-0" style="color:black; font-size: 22px;">Start your free trial — No credit card required</h2>
      </div>
      <div class="col-md-5 d-flex align-items-center">
        <form action="#" class="subscribe-form">
          <div class="form-group d-flex">
            <input type="text" class="form-control" placeholder="Enter email address">
            <input type="submit" value="Start Free Trial" class="submit px-3">
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section bg-light">
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section text-center ftco-animate">
        <span class="subheading">Price &amp; Plans</span>
        <h2>Affordable Packages</h2>
      </div>
    </div>
    <div class="row">
      <?php foreach ($plans as $p): ?>
        <div class="col-md-6 col-lg-3 ftco-animate">
          <div class="block-7">
            <div class="text-center">
              <span class="excerpt d-block"><?= e($p['name']) ?></span>
              <span class="price"><sup>$</sup> <span class="number"><?= (int)$p['price'] ?></span> <sub>/mos</sub></span>
              <ul class="pricing-text mb-5">
                <?php foreach ($p['features'] as $f): ?>
                  <li><span class="fa fa-check mr-2"></span><?= e($f) ?></li>
                <?php endforeach; ?>
              </ul>
              <a href="#" class="btn btn-primary d-block px-2 py-3">Get Started</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ================== End page content ================== -->

<?php require_once __DIR__ . '/partials/footer.php'; ?>
