<?php
// partials/header.php
require_once __DIR__ . '/../inc/config.php';

// Page-level defaults if not set by the including file
$pageTitle = $pageTitle ?? ($siteName . ' - Free Bootstrap 4 Site by Colorlib');
$activePage = $activePage ?? 'home';
?>
<!DOCTYPE html>
<html lang="en">

<head>
     <title><?= e($pageTitle) ?></title>
     <meta charset="utf-8">
     <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

     <link href="https://fonts.googleapis.com/css?family=Montserrat:200,300,400,500,600,700,800&display=swap"
          rel="stylesheet">
     <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

     <link rel="stylesheet" href="<?= e($ASSET_BASE) ?>css/animate.css">
     <link rel="stylesheet" href="<?= e($ASSET_BASE) ?>css/owl.carousel.min.css">
     <link rel="stylesheet" href="<?= e($ASSET_BASE) ?>css/owl.theme.default.min.css">
     <link rel="stylesheet" href="<?= e($ASSET_BASE) ?>css/magnific-popup.css">
     <link rel="stylesheet" href="<?= e($ASSET_BASE) ?>css/flaticon.css">
     <link rel="stylesheet" href="<?= e($ASSET_BASE) ?>css/style.css">
</head>

<body>

     <div class="wrap">
          <div class="container">
               <div class="row">
                    <div class="col-md-12">
                         <div class="bg-wrap">
                              <div class="row">
                                   <div class="col-md-6 d-flex align-items-center">
                                        <p class="mb-0 phone pl-md-2">
                                             <a href="#" class="mr-2"><span class="fa fa-phone mr-1"></span>
                                                  <?= e($contact['phone']) ?></a>
                                             <a href="mailto:<?= e($contact['email']) ?>"><span
                                                       class="fa fa-paper-plane mr-1"></span>
                                                  <?= e($contact['email']) ?></a>
                                        </p>
                                   </div>
                                   <div class="col-md-6 d-flex justify-content-md-end">
                                        <div class="social-media">
                                             <p class="mb-0 d-flex">
                                                  <a href="#"
                                                       class="d-flex align-items-center justify-content-center"><span
                                                            class="fa fa-facebook"><i
                                                                 class="sr-only">Facebook</i></span></a>
                                                  <a href="#"
                                                       class="d-flex align-items-center justify-content-center"><span
                                                            class="fa fa-twitter"><i
                                                                 class="sr-only">Twitter</i></span></a>
                                                  <a href="#"
                                                       class="d-flex align-items-center justify-content-center"><span
                                                            class="fa fa-instagram"><i
                                                                 class="sr-only">Instagram</i></span></a>

                                             </p>
                                        </div>
                                   </div>
                              </div>
                         </div><!-- .bg-wrap -->
                    </div>
               </div>
          </div>
     </div>

     <nav class="navbar navbar-expand-lg navbar-dark ftco_navbar bg-dark ftco-navbar-light" id="ftco-navbar">
          <div class="container">
               <a class="navbar-brand" href="<?= e($ASSET_BASE) ?>index.php"><?= e($siteName) ?></a>
               <form action="#" class="searchform order-sm-start order-lg-last">
                    <div class="form-group d-flex">
                         <input type="text" class="form-control pl-3" placeholder="Search">
                         <button type="submit" class="form-control search"><span class="fa fa-search"></span></button>
                    </div>
               </form>
               <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#ftco-nav"
                    aria-controls="ftco-nav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="fa fa-bars"></span> Menu
               </button>
               <div class="collapse navbar-collapse" id="ftco-nav">
                    <ul class="navbar-nav m-auto">
                         <?php foreach ($menus as $m): ?>
                              <li class="nav-item <?= ($activePage === $m['slug']) ? 'active' : '' ?>">
                                   <a class="nav-link" href="<?= e($ASSET_BASE . $m['href']) ?>"><?= e($m['label']) ?></a>
                              </li>
                         <?php endforeach; ?>
                    </ul>


                    <?php if (empty($auth['logged_in'])): ?>
                         <!-- Login button (desktop) -->
                         <a href="<?= e($auth['login_href']) ?>"
                              class="btn btn-primary ml-lg-3 px-3 d-none d-lg-inline-flex">
                              <?= e($auth['login_label']) ?>
                         </a>
                         <!-- Login button (mobile, inside collapse) -->
                         <a href="<?= e($auth['login_href']) ?>" class="btn btn-primary px-3 mt-3 d-lg-none">
                              <?= e($auth['login_label']) ?>
                         </a>
                    <?php else: ?>
                         <!-- Account dropdown if logged in -->
                         <div class="dropdown ml-lg-3 mt-3 mt-lg-0">
                              <a class="btn btn-outline-light dropdown-toggle px-3" href="#" role="button"
                                   data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                   <?= e($auth['user_name'] ?? 'Account') ?>
                              </a>
                              <div class="dropdown-menu dropdown-menu-right">
                                   <a class="dropdown-item" href="dashboard.php">Dashboard</a>
                                   <div class="dropdown-divider"></div>
                                   <a class="dropdown-item" href="<?= e($auth['logout_href']) ?>">Log out</a>
                              </div>
                         </div>
                    <?php endif; ?>

               </div>
          </div>
     </nav>
     <!-- END nav -->