<?php
// services.php — uses reusable header/footer

// Page settings
$pageTitle  = 'Services - Accounting';
$activePage = 'services';          // must match a slug in $menus
// $ASSET_BASE = '';               // set to '../' if this file is in a subfolder

// Data for this page
$hero = [
  'bg'   => 'images/bg_2.jpg',
  'title'=> 'Services',
  'crumbs'=> [
    ['label' => 'Home', 'href' => 'index.php'],
    ['label' => 'Services', 'href' => null],
  ],
];

$featureServices = [
  ['icon' => 'flaticon-accounting-1', 'title' => 'Accounting',                'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
  ['icon' => 'flaticon-tax',          'title' => 'Tax, Compliance & Payroll', 'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
  ['icon' => 'flaticon-loan',         'title' => 'Financial Services',        'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
  ['icon' => 'flaticon-budget',       'title' => 'Growth & Funding Access',   'text' => 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.'],
];

$servicesList = [
  ['icon' => 'flaticon-wealth',     'title' => 'Market Analysis',       'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
  ['icon' => 'flaticon-accountant', 'title' => 'Accounting Advisor',    'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
  ['icon' => 'flaticon-teamwork',   'title' => 'General Consultancy',   'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
  ['icon' => 'flaticon-accounting', 'title' => 'Structured Assestment', 'text' => 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia'],
];

$plans = [
  ['name' => 'Personal', 'price' => 49,  'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
  ['name' => 'Business', 'price' => 79,  'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
  ['name' => 'Ultimate', 'price' => 109, 'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
  ['name' => 'Premium',  'price' => 149, 'features' => ['Brand Strategy','Online Marketing','Branding Services','Creative Marketing','Sales Management']],
];

// Include header (loads config + <head> + navbar)
require_once __DIR__ . '/partials/header.php';
?>

<!-- ================== PAGE CONTENT ================== -->

<section class="hero-wrap hero-wrap-2" style="background-image: url('<?= e($hero['bg']) ?>');" data-stellar-background-ratio="0.5">
  <div class="overlay"></div>
  <div class="container">
    <div class="row no-gutters slider-text align-items-end">
      <div class="col-md-9 ftco-animate pb-5">
        <p class="breadcrumbs mb-2">
          <?php foreach ($hero['crumbs'] as $i => $c): ?>
            <span class="<?= $i === 0 ? 'mr-2' : '' ?>">
              <?php if (!empty($c['href'])): ?>
                <a href="<?= e($c['href']) ?>"><?= e($c['label']) ?> <i class="ion-ios-arrow-forward"></i></a>
              <?php else: ?>
                <?= e($c['label']) ?> <i class="ion-ios-arrow-forward"></i>
              <?php endif; ?>
            </span>
          <?php endforeach; ?>
        </p>
        <h1 class="mb-0 bread"><?= e($hero['title']) ?></h1>
      </div>
    </div>
  </div>
</section>

<section class="ftco-section">
  <div class="container">
    <div class="row">
      <?php foreach ($featureServices as $svc): ?>
        <div class="col-md-6 col-lg-3 d-flex services align-self-stretch px-4 ftco-animate">
          <div class="d-block">
            <div class="icon d-flex mr-2">
              <span class="<?= e($svc['icon']) ?>"></span>
            </div>
            <div class="media-body">
              <h3 class="heading"><?= e($svc['title']) ?></h3>
              <p><?= e($svc['text']) ?></p>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pt bg-light">
  <div class="container">
    <div class="row d-flex no-gutters">
      <div class="col-md-6 d-flex">
        <div class="img img-video d-flex align-self-stretch align-items-center justify-content-center justify-content-md-center mb-4 mb-sm-0" style="background-image:url(images/about.jpg);"></div>
      </div>
      <div class="col-md-6 pl-md-5 py-md-5">
        <div class="heading-section pl-md-4 pt-md-5">
          <span class="subheading">Welcome to Accounting</span>
          <h2 class="mb-4">We Are the Best Accounting Agency</h2>
        </div>

        <?php foreach ($servicesList as $svc): ?>
          <div class="services-2 w-100 d-flex">
            <div class="icon d-flex align-items-center justify-content-center"><span class="<?= e($svc['icon']) ?>"></span></div>
            <div class="text pl-4">
              <h4><?= e($svc['title']) ?></h4>
              <p><?= e($svc['text']) ?></p>
            </div>
          </div>
        <?php endforeach; ?>

      </div>
    </div>
  </div>
</section>

<section class="ftco-section bg-light ftco-no-pt">
  <div class="container">
    <div class="row justify-content-center pb-5 mb-3">
      <div class="col-md-7 heading-section text-center ftco-animate">
        <span class="subheading">Price &amp; Plans</span>
        <h2>Affordable Packages</h2>
      </div>
    </div>
    <div class="row">
      <?php foreach ($plans as $p): ?>
        <div class="col-md-6 col-lg-3 ftco-animate">
          <div class="block-7">
            <div class="text-center">
              <span class="excerpt d-block"><?= e($p['name']) ?></span>
              <span class="price"><sup>$</sup> <span class="number"><?= (int)$p['price'] ?></span> <sub>/mos</sub></span>
              <ul class="pricing-text mb-5">
                <?php foreach ($p['features'] as $f): ?>
                  <li><span class="fa fa-check mr-2"></span><?= e($f) ?></li>
                <?php endforeach; ?>
              </ul>
              <a href="#" class="btn btn-primary d-block px-2 py-3">Get Started</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<section class="ftco-section ftco-no-pb ftco-no-pt bg-secondary">
  <div class="container py-5">
    <div class="row">
      <div class="col-md-7 d-flex align-items-center">
        <h2 class="mb-3 mb-sm-0" style="color:black; font-size: 22px;">Sign Up for Your Free 1st Accounting Consultation</h2>
      </div>
      <div class="col-md-5 d-flex align-items-center">
        <form action="#" class="subscribe-form">
          <div class="form-group d-flex">
            <input type="text" class="form-control" placeholder="Enter email address">
            <input type="submit" value="Subscribe" class="submit px-3">
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ================== /PAGE CONTENT ================== -->

<?php require_once __DIR__ . '/partials/footer.php'; ?>
